<?php
// -- Include the required data and requirements for this page
include("templates/headers/inc.php");

// Include the JS file
$js_files = array("js/pages/home.js");

// Metadata informations of this page
$page_title = "Home - My Quiz";
$page_slug	= "home";

// Get website config
$site_config = $dbh->prepare("SELECT * FROM config WHERE config_name IN ('website_name','website_tagline','ads_code')");
$site_config->execute();

$config_array = array();

while($config = $site_config->fetch(PDO::FETCH_ASSOC)) {
	$config_array[$config["config_name"]] = $config["config_value"];
}

$website_name = $config_array["website_name"];
$website_tagline = $config_array["website_tagline"];
$ads_code = $config_array["ads_code"];

// -- General checks and redirects
// If we have a session, redirect !
if(!$_SESSION || !isset($_SESSION["USER_ID"])) {
	header("Location: index.php?action=need_log_in");
	exit;
}

$user_id = $_SESSION["USER_ID"];

if(!isset($_GET["id"])) {
	header("Location: home.php?action=forbidden");
	exit;		
}

$page_id = intval($_GET["id"]);

// Check if user exists...
$page_sql = $dbh->prepare("	SELECT *
							FROM custom_page
							WHERE id = :page_id
							");
					
$page_sql->bindParam(':page_id', $page_id);
$page_sql->execute();
	
$page = $page_sql->fetch();

$title_page = $page["title"];
$content_page = $page["content"];

	
// -- Include the header template
include("templates/headers/global_header.php");
?>

<?php
if($ads_code != "") {
?>
<div class="row">
	<div class="col-md-12">
		<?php
		echo $ads_code;
		?>
	</div>
</div>
<?php
}	
?>

<div class="row">

	<div class="inner-container">
		<center>
			<a class="btn btn-primary btn-create-quiz" href="create-quiz.php"><i class="em em-computer"></i> Create a Quiz</a>
			<?php
			if($_SESSION["RANK"] == 1) {	
			?>
			<a class="btn btn-danger btn-admin-area" href="admin.php"><i class="em em-closed_lock_with_key"></i> Admin Area</a>
			<?php
			}
			?>
		</center>
		<br />
		<div class="inner-container content" id="main-content">
					
			<h3><?php echo $title_page; ?></h3>
			
			<div class="content-inner">	
				<?php echo $content_page; ?>
			</div>
		
		</div>
	</div>
					
</div>

<?php
// -- Include the footer template
include("templates/footers/global_footer.php");	
?>